@extends('layouts.guest')

@section('title', 'Confirm your password')

@section('styles')
    @parent

@endsection

@section('content')
    <section class=" auth">
        <div class="container">
            <div class="pb-3 row justify-content-center">

                <div class="col-12 col-md-6 col-lg-6 col-sm-10 col-xl-6">


                    <div class="bg-white shadow card login-page roundedd border-1 ">
                        <div class="card-body">
                            <p class="text-sm text-center text-primary"> This is a secure area. Please confirm your password
                                before continuing.</h4>
                            <form method="POST" action="{{ route('password.confirm') }}" class="mt-4 login-form">
                                @csrf
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <label>Enter Password <span class="text-danger">*</span></label>
                                            <div class="position-relative">
                                                <i data-feather="key" class="fea icon-sm icons"></i>
                                                <input type="password" class="pl-5 form-control" name="password" required
                                                    autocomplete="current-password" autofocus>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        @if ($errors->any())
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li class="text-danger">{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        @endif
                                    </div>
                                    <!--end col-->

                                    <div class="mb-0 col-lg-12">
                                        <button class="btn btn-primary btn-block pad" type="submit">Confirm</button>
                                    </div>

                                </div>
                                <!--end row-->
                            </form>
                        </div>
                    </div>
                    <!---->
                </div>
                <!--end col-->
            </div>
            <!--end row-->
        </div>
        <!--end container-->
    </section>
    <!--end section-->



@endsection

@section('scripts')
    @parent

@endsection
